/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.string;

import java.io.IOException;
import java.io.Reader;
import ru.yandex.util.string.NormalizingProcessor;

public class NormalizingReader
extends Reader {
    private final NormalizingProcessor processor = new NormalizingProcessor();
    private final char[] buf = new char[1028];
    private final Reader reader;
    private int len = 0;

    public NormalizingReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        this.len = 0;
        this.reader.close();
    }

    private void fillBuffer() throws IOException {
        int read;
        while (this.len < this.buf.length && (read = this.reader.read(this.buf, this.len, this.buf.length - this.len)) != -1) {
            this.len += read;
        }
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.processor.isEmpty()) {
            this.fillBuffer();
            if (this.len < this.buf.length) {
                this.processor.process(this.buf, 0, this.len);
                this.len = 0;
            } else {
                int i;
                int blockSize = 1025;
                for (i = 0; i < 4; ++i) {
                    if (!NormalizingProcessor.good(this.buf[1024 + i])) continue;
                    blockSize = 1024 + i;
                    break;
                }
                this.processor.process(this.buf, 0, blockSize);
                for (i = blockSize; i < this.buf.length; ++i) {
                    this.buf[i - blockSize] = this.buf[i];
                }
                this.len -= blockSize;
            }
        }
        int result = this.processor.isEmpty() ? -1 : this.processor.transferTo(buf, off, len);
        return result;
    }
}

