/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.string;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;

public interface StringUtils {
    public static final int BUFFER_SIZE = 2048;

    public static String from(Reader reader) throws IOException {
        char[] buf = new char[2048];
        StringBuilder sb = new StringBuilder();
        int read;
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        return new String(sb);
    }

    public static int strlen(String str) {
        if (str == null) {
            return 4;
        }
        return str.length();
    }

    public static String concat(String str1, String str2) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2));
        sb.append(str1);
        sb.append(str2);
        return new String(sb);
    }

    public static String concat(String str1, String str2, String str3) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2) + StringUtils.strlen(str3));
        sb.append(str1);
        sb.append(str2);
        sb.append(str3);
        return new String(sb);
    }

    public static String concat(String str1, char delimiter, String str2) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2) + 1);
        sb.append(str1);
        sb.append(delimiter);
        sb.append(str2);
        return new String(sb);
    }

    public static String concat(char prefix, String str) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str) + 1);
        sb.append(prefix);
        sb.append(str);
        return new String(sb);
    }

    public static String concat(String str, char suffix) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str) + 1);
        sb.append(str);
        sb.append(suffix);
        return new String(sb);
    }

    public static String concat(char prefix, String str, char suffix) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str) + 2);
        sb.append(prefix);
        sb.append(str);
        sb.append(suffix);
        return new String(sb);
    }

    public static String concat(char prefix, String str1, String str2, String str3) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2) + StringUtils.strlen(str3) + 1);
        sb.append(prefix);
        sb.append(str1);
        sb.append(str2);
        sb.append(str3);
        return new String(sb);
    }

    public static String concat(String str1, String str2, String str3, char suffix) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2) + StringUtils.strlen(str3) + 1);
        sb.append(str1);
        sb.append(str2);
        sb.append(str3);
        sb.append(suffix);
        return new String(sb);
    }

    public static String concat(String str1, char delimiter1, String str2, char delimiter2, String str3) {
        StringBuilder sb = new StringBuilder(StringUtils.strlen(str1) + StringUtils.strlen(str2) + StringUtils.strlen(str3) + 2);
        sb.append(str1);
        sb.append(delimiter1);
        sb.append(str2);
        sb.append(delimiter2);
        sb.append(str3);
        return new String(sb);
    }

    public static String join(Collection<String> strings, char delimiter) {
        return new String(StringUtils.join(strings, delimiter, "", 0));
    }

    public static String join(Collection<String> strings, String delimiter) {
        return new String(StringUtils.join(strings, delimiter, "", 0));
    }

    public static String join(String[] values, char delimiter) {
        return StringUtils.join(values, delimiter, "", "");
    }

    public static String join(String[] values, String delimiter) {
        return StringUtils.join(values, delimiter, "", "");
    }

    public static String join(Collection<String> strings, char delimiter, String prefix, String suffix) {
        return new String(StringUtils.join(strings, delimiter, prefix, suffix.length()).append(suffix));
    }

    public static String join(Collection<String> strings, String delimiter, String prefix, String suffix) {
        return new String(StringUtils.join(strings, delimiter, prefix, suffix.length()).append(suffix));
    }

    public static String join(String[] strings, char delimiter, String prefix, String suffix) {
        return new String(StringUtils.join(strings, delimiter, prefix, suffix.length()).append(suffix));
    }

    public static String join(String[] strings, String delimiter, String prefix, String suffix) {
        return new String(StringUtils.join(strings, delimiter, prefix, suffix.length()).append(suffix));
    }

    public static StringBuilder join(Collection<String> strings, char delimiter, String prefix, int overhead) {
        StringBuilder sb;
        int size = strings.size();
        switch (size) {
            case 0: {
                sb = new StringBuilder(prefix.length() + overhead);
                sb.append(prefix);
                break;
            }
            case 1: {
                String str = strings.iterator().next();
                sb = new StringBuilder(StringUtils.strlen(str) + prefix.length() + overhead);
                sb.append(prefix);
                sb.append(str);
                break;
            }
            default: {
                int i;
                int length = prefix.length() + overhead + size - 1;
                Iterator<String> iter = strings.iterator();
                for (i = 0; i < size; ++i) {
                    length += StringUtils.strlen(iter.next());
                }
                sb = new StringBuilder(length);
                sb.append(prefix);
                iter = strings.iterator();
                sb.append(iter.next());
                for (i = 1; i < size; ++i) {
                    sb.append(delimiter);
                    sb.append(iter.next());
                }
            }
        }
        return sb;
    }

    public static StringBuilder join(Collection<String> strings, String delimiter, String prefix, int overhead) {
        StringBuilder sb;
        int size = strings.size();
        switch (size) {
            case 0: {
                sb = new StringBuilder(prefix.length() + overhead);
                sb.append(prefix);
                break;
            }
            case 1: {
                String str = strings.iterator().next();
                sb = new StringBuilder(StringUtils.strlen(str) + prefix.length() + overhead);
                sb.append(prefix);
                sb.append(str);
                break;
            }
            default: {
                int i;
                int length = prefix.length() + overhead + (size - 1) * delimiter.length();
                Iterator<String> iter = strings.iterator();
                for (i = 0; i < size; ++i) {
                    length += StringUtils.strlen(iter.next());
                }
                sb = new StringBuilder(length);
                sb.append(prefix);
                iter = strings.iterator();
                sb.append(iter.next());
                for (i = 1; i < size; ++i) {
                    sb.append(delimiter);
                    sb.append(iter.next());
                }
            }
        }
        return sb;
    }

    public static StringBuilder join(String[] strings, char delimiter, String prefix, int overhead) {
        StringBuilder sb;
        int size = strings.length;
        switch (size) {
            case 0: {
                sb = new StringBuilder(prefix.length() + overhead);
                sb.append(prefix);
                break;
            }
            case 1: {
                String str = strings[0];
                sb = new StringBuilder(StringUtils.strlen(str) + prefix.length() + overhead);
                sb.append(prefix);
                sb.append(str);
                break;
            }
            default: {
                int length = prefix.length() + overhead + size - 1;
                for (String string : strings) {
                    length += StringUtils.strlen(string);
                }
                sb = new StringBuilder(length);
                sb.append(prefix);
                sb.append(strings[0]);
                for (int i = 1; i < size; ++i) {
                    sb.append(delimiter);
                    sb.append(strings[i]);
                }
            }
        }
        return sb;
    }

    public static StringBuilder join(String[] strings, String delimiter, String prefix, int overhead) {
        StringBuilder sb;
        int size = strings.length;
        switch (size) {
            case 0: {
                sb = new StringBuilder(prefix.length() + overhead);
                sb.append(prefix);
                break;
            }
            case 1: {
                String str = strings[0];
                sb = new StringBuilder(StringUtils.strlen(str) + prefix.length() + overhead);
                sb.append(prefix);
                sb.append(str);
                break;
            }
            default: {
                int length = prefix.length() + overhead + (size - 1) * delimiter.length();
                for (String string : strings) {
                    length += StringUtils.strlen(string);
                }
                sb = new StringBuilder(length);
                sb.append(prefix);
                sb.append(strings[0]);
                for (int i = 1; i < size; ++i) {
                    sb.append(delimiter);
                    sb.append(strings[i]);
                }
            }
        }
        return sb;
    }
}

