/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import mx4j.remote.MX4JRemoteUtils;
import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.Connection;
import mx4j.tools.remote.ConnectionManager;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private AbstractJMXConnectorServer server;
    private final Map environment;
    private final AccessControlContext context;
    private final Map connections = new HashMap();
    private volatile boolean closed;

    protected AbstractConnectionManager(AbstractJMXConnectorServer server, Map environment) {
        this.server = server;
        this.environment = environment;
        this.context = AccessController.getContext();
    }

    protected void setJMXConnectorServer(AbstractJMXConnectorServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection connect(Object credentials) throws IOException, SecurityException {
        if (this.isClosed()) {
            throw new IOException("This connection manager is already closed " + this);
        }
        Subject subject = this.authenticate(credentials);
        String connectionId = this.createConnectionID(subject);
        Connection client = this.doConnect(connectionId, subject);
        WeakReference<Connection> weak = new WeakReference<Connection>(client);
        Map map = this.connections;
        synchronized (map) {
            this.connections.put(connectionId, weak);
        }
        this.server.connectionOpened(connectionId, "Connection opened " + client, null);
        return client;
    }

    protected String createConnectionID(Subject subject) {
        return MX4JRemoteUtils.createConnectionID(this.getProtocol(), null, -1, subject);
    }

    protected abstract Connection doConnect(String var1, Subject var2) throws IOException;

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.doClose();
        this.closeConnections();
    }

    protected abstract void doClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeConnections() throws IOException {
        IOException clientException = null;
        Map map = this.connections;
        // MONITORENTER : map
        while (true) {
            if (this.connections.isEmpty()) {
                // MONITOREXIT : map
                if (clientException == null) return;
                throw clientException;
            }
            Iterator entries = this.connections.entrySet().iterator();
            Map.Entry entry = entries.next();
            WeakReference weak = (WeakReference)entry.getValue();
            Connection connection = (Connection)weak.get();
            if (connection == null) {
                entries.remove();
                continue;
            }
            try {
                connection.close();
            }
            catch (IOException x) {
                if (clientException != null) continue;
                clientException = x;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws IOException {
        String connectionID = connection.getConnectionId();
        WeakReference weak = null;
        Map map = this.connections;
        synchronized (map) {
            weak = (WeakReference)this.connections.remove(connectionID);
        }
        if (weak == null) {
            return;
        }
        Connection client = (Connection)weak.get();
        if (connection != client) {
            throw new IOException("Could not find active connection " + connection + ", expecting " + client);
        }
        this.doCloseConnection(connection);
        this.server.connectionClosed(connectionID, "Closed connection " + connection, null);
    }

    protected abstract void doCloseConnection(Connection var1) throws IOException;

    protected boolean isClosed() {
        return this.closed;
    }

    protected Map getEnvironment() {
        return this.environment;
    }

    protected AccessControlContext getSecurityContext() {
        return this.context;
    }

    protected Subject authenticate(Object credentials) throws IOException, SecurityException {
        JMXAuthenticator authenticator;
        Map environment = this.getEnvironment();
        if (environment != null && (authenticator = (JMXAuthenticator)environment.get("jmx.remote.authenticator")) != null) {
            return authenticator.authenticate(credentials);
        }
        return null;
    }
}

