package ru.yandex.chemodan.app.idmapi;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.admin.ChemodanAdminDaemonContextConfiguration;
import ru.yandex.chemodan.boot.admin.idm.AppsRegistry;
import ru.yandex.chemodan.boot.admin.idm.IdmAppsRegistryContextConfiguration;
import ru.yandex.chemodan.boot.admin.idm.IdmUsersRegistryContextConfiguration;
import ru.yandex.chemodan.boot.admin.idm.UsersRegistry;
import ru.yandex.chemodan.util.idm.IdmActions;
import ru.yandex.chemodan.util.idm.IdmUtils;
import ru.yandex.chemodan.util.idm.RoleSpecificationConverter;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.NS;
import ru.yandex.chemodan.util.web.SuppressInvocationInfoJsonPojoResultSerializer;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.parameter.convert.DefaultConverters;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.SimpleResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author swined
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class,
        IdmUsersRegistryContextConfiguration.class,
        IdmAppsRegistryContextConfiguration.class,
        ZkAdminContextConfiguration.class,
        ChemodanCommonContextConfiguration.class,
        ChemodanAdminDaemonContextConfiguration.class
})
public class IdmApiContextConfiguration {

    @Bean
    public IdmTools idmTools(AppsRegistry appsRegistry, UsersRegistry usersRegistry) {
        return new IdmTools(appsRegistry, usersRegistry);
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {
        ListF<CloneableAction> cloneableActions = ApplicationContextUtils
                .beansOfType(context, CloneableAction.class);

        ListF<Object> actionContainers = ApplicationContextUtils
                .beansWithAnnotationList(context, ActionContainer.class)
                .get2();

        ActionConfigurationBuilder builder = ActionConfigurationBuilder
                .cons(applicationInfo)
                .setConverters(DefaultConverters.all().getConverters().plus1(new RoleSpecificationConverter()))

                .setResultSerializers(Cf.list(
                        new SimpleResultSerializer(),
                        new SuppressInvocationInfoJsonPojoResultSerializer(IdmUtils.mapper)))

                .setParameterBinders(Cf.list(
                        new BenderJsonParameterBinder(new BenderMapper())))

                .setInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo)))

                .setResultType(MediaType.APPLICATION_JSON);

        return ActionConfigurator.configure(actionContainers.plus(cloneableActions), builder);
    }

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs("/idm/*", NS.API));
    }

    @Bean
    public IdmRegistriesRoutines idmRegistriesRoutines(AliveAppsHolder holder, UsersRegistry usersRegistry) {
        return new IdmRegistriesRoutines(holder, usersRegistry);
    }

    @Bean
    public IdmActions idmActions(IdmRegistriesRoutines registriesRoutines) {
        return new IdmActions(registriesRoutines);
    }

}
