package ru.yandex.chemodan.app.idmapi;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;

/**
 * @author swined
 */
@AllArgsConstructor
public enum Role {

    READ("Доступ в админку", "Admin page access"),
    SUPER("Доступ ко всему", "superuser access"),
    EXECUTE("Выполнение скриптов", "Script execution"),
    SCRIPTER("Выполнение заранее подготовленных сскриптов", "Prepared Script execution"),
    DATASYNC("Доступ к датасинку", "Datasync access"),
    UAAS("Доступ к оверрайдам UAAS", "UAAS overrides access"),
    ZK("Доступ к ZK", "ZK access"),
    ZK_WRITE("Доступ к ZK на запись", "ZK write access"),
    TELEMOST_CLIENT_CONFIGURATION("Доступ к редактированию клиентской конфигурации Телемоста",
            "Edit Telemost client configuration access"),
    CARE("Права на выдачу CARE", "Rights to issue CARE"),
    PROMO("Права на изменение промоакций", "Rights to edit promoactions"),
    PARTNER("Доступ к управлению партнёрскими организациями", "Partner organizations management access");

    public final String ru;
    public final String en;

    public static Option<Role> parse(String str) {
        return Cf.list(Role.values()).filter(role -> role.name().equals(str)).firstO();
    }

}
