class DCInfo:
    def __init__(self, name, is_closed=False, is_dbs_closed=False, excluded_apps=[], force_closed_apps=[], json=None):
        self.name = name
        if json is None:
            self.is_closed = is_closed
            self.is_dbs_closed = is_dbs_closed
            self.excluded_apps = excluded_apps
            self.force_closed_apps = force_closed_apps
        else:
            self.is_closed = json['isClosed']
            self.is_dbs_closed = json['isDbsClosed']
            self.excluded_apps = json['excludedApps']
            self.force_closed_apps = json['forceClosedApps']

    def is_app_closed(self, appname, is_db):
        dc_close_param = self.is_dbs_closed if is_db else self.is_closed
        return appname in self.force_closed_apps or (dc_close_param and appname not in self.excluded_apps)
