from .commands import execute_command
from .zookeeper import ZookeeperDeploy
import time


class DeployRestarter:
    def __init__(self, config):
        self.config = config
        self.zk_purge_expired_time = config.restarter.zk_purge_expired_time
        self.max_downtime_hosts = config.restarter.max_downtime_hosts
        self.logger = config.logger
        self.zk = ZookeeperDeploy(config)
        self.zk._reset()
        self.zk.restart()

    def is_restart_available(self):
        childs = self.zk.get_childs()
        available = self.max_downtime_hosts
        for c in childs:
            if not self.is_node_old(c):
                available -= 1
        return available > 0


    def is_node_old(self, node):
        # Check if node is old enough to be removed
        node_age = self.zk.get_node_mtime(node)
        if node_age and time.time() - node_age > self.zk_purge_expired_time:
            self.logger.warning("Remove old node: %s" % node)
            self.zk.delete_node(node)
            return True
        return False


