from .logger import tskv_escape


class Status:
    def __init__(self, message="", code=0, is_closed=None, is_zk_connected=False, is_disabled=False, logger=None):
        self.logger = logger
        self.is_disabled = is_disabled
        self.is_zk_connected = is_zk_connected
        self.is_closed = is_closed
        self.code = code
        self.message = message

    def log(self):
        message = "%d;%s" % (self.code, self.message)
        message += "\ttype=status"
        message += "\tisZKConnected=%s" % self.is_zk_connected
        message += "\tisDisabled=%s" % self.is_disabled
        self.logger.info(message)

    def error(self, exception):
        self.code = 2
        self.message = tskv_escape(exception)
        return self

    def disable(self):
        self.code = 1
        self.is_disabled = 1
        self.message = "Disabled"
        self.is_closed = None
        return self
