import requests
import os
from lib.util import get_url

#from urllib.parse import quote
from urllib import quote
import sys
import warnings
from dataclasses import dataclass


class Oops:
    oops_url = 'https://oops.yandex-team.ru/api/ui/query/page'
    token = os.getenv("CONDUCTOR_TOKEN")
    if not token:
        raise EnvironmentError("$CONDUCTOR_TOKEN is not set")
    oauth_header = {"Authorization": "OAuth %s" % token}

    @classmethod
    def req(cls, params, page_size = 99999):
        params.update({'page-size': page_size})
        url = '{}?{}'.format(cls.oops_url,
                             '&'.join('{}={}'.format(quote(str(k)), quote(str(v))) for k, v in params.items()))
        result = get_url(url, to_json=True, headers=cls.oauth_header)
        if result['pagesCount'] > 1:
            warnings.warn("Answer has more than %s entries" % page_size)

        return result['pageCollection']

    @classmethod
    def get_disk_items(cls):
        return cls.req({'expression': 'botStatus.project=="Search Portal > Personal and Infrastructure Services > Personal products > Yandex.Disk"'})

oops = Oops()
