import statface_client
import yaml
import sys
import os

if __name__ == '__main__':
    if len(sys.argv) <= 1:
        exit("Pass config name as argument")
    config_name = sys.argv[1]
    conf = yaml.safe_load(open(config_name))
    client = statface_client.StatfaceClient(oauth_token=os.getenv(conf['token_env']), host=statface_client.STATFACE_PRODUCTION)
    report = client.get_report(conf['path'])

    print("Overwriting old config:\n%s" % report.config)
    report.upload_config(conf['data_config'])
