# -*- coding: utf-8 -*-
import multiprocessing
from multiprocessing.managers import State
from os import getenv

from tornado import web

from .conductor import ConductorAPI
from .deploy import DeployAPI
from .domains import DomainsAPI
from .infra import InfraAPI
from .juggler import JugglerAPI
from .qloud import QloudAPI
from .telegram import TelegramAPI


class Application(web.Application):

    __LOCK__ = multiprocessing.Lock()

    def __init__(self, config, handlers, state):
        super(Application, self).__init__(handlers)

        self.config = config
        self.tries = self.config["settings"].get('tries', 3)
        self.timeout = self.config["settings"].get('timeout', 10)

        self.conductor_api = ConductorAPI(
            self.config['settings']['conductor_api_ro_url'],
            self.config['settings']['conductor_api_rw_url'],
            getenv(self.config['settings']['conductor_api_token_env'])
        )

        self.qloud_api = QloudAPI(
            self.config['settings']['qloud_api_url'],
            getenv(self.config['settings']['qloud_api_token_env'])
        )

        self.deploy_api = DeployAPI(
            getenv(self.config['settings']['yp_token_env'])
        )

        self.domains_api = DomainsAPI(
            self.config['settings']['dns_api_url'],
            self.config['settings']['dns_api_primitives_url'],
            getenv(self.config['settings']['dns_api_token_env']),
            self.config['settings']['dns_api_login'],
        )

        self.telegram_api = TelegramAPI(
            getenv(self.config['settings']['telegram']['token']),
            getenv(self.config['settings']['telegram']['chat_id']),
            self.config['settings']['notified_environments'],
        )

        self.juggler_api = JugglerAPI(
            self.config['settings']['juggler_api']['url'],
            getenv(self.config['settings']['juggler_api']['token_env']),
            self.config['settings']['juggler_api']['dt_services'],
            self.config['settings']['juggler_api']['dt_statuses']
        )

        self.infra_api = InfraAPI(
            self.config['settings']['infra_api']['url'],
            getenv(self.config['settings']['infra_api']['token_env']),
            self.config['settings']['infra_api']['service_id'],
            self.config['settings']['infra_api']['environment_id'],
            self.config['settings']['notified_environments'],
        )

        #: websocket connections // reserved for future
        self.connections = dict()

        #: shared state between this proc and it subprocesses
        self.state = state

    @property
    def running(self):
        return self.state.value != State.SHUTDOWN
