# -*- coding: utf-8 -*-
import json
import time
from urlparse import urljoin

from tornado.gen import coroutine
from tornado.httpclient import AsyncHTTPClient


class JugglerAPI(object):

    def __init__(self, api_url, token, dt_services, status):
        self.api_url = api_url
        self.token = token
        self.dt_services = dt_services
        self.status = status
        self.namespace = 'disk-qloud'
        self.headers = {
            'Authorization': 'OAuth %s' % token,
            'Accept': 'application/json; charset=utf-8',
            'Content-Type': 'application/json',
        }

    def generate_url(self, endpoint):
        return urljoin(self.api_url, endpoint)

    @coroutine
    def downtime(self, environment):
        try:
            filters = [
                {
                    'tags': ['qloud-ext.' + environment.environment_id],
                    'service': service,
                    'namespace': self.namespace,
                } for service in self.dt_services
            ]
            params = json.dumps({
                'filters': filters,
                'end_time': time.time() + 1800,
                'description': u'%s, url: %s' % (environment.comment, environment.url),
                'source': 'conductor-sync',
            })
            URL = self.generate_url('downtimes/set_downtimes')
            client = AsyncHTTPClient()
            environment.logger.debug('Set downtime in juggler')
            response = yield client.fetch(URL, method='POST', raise_error=False, body=params, headers=self.headers)

            if response.error:
                environment.logger.error('Unable to set downtime => %s' % response.error.message)

            else:
                try:
                    result = json.loads(response.body)
                    environment.logger.debug('Downtime enabled, downtime_id=%s' % result['downtime_id'])
                except Exception as e:
                    environment.logger.critical('Unable to parse JSON from Juggler => %s' % e.message)

        except Exception as e:
            environment.logger.error('Uncaught exception while set downtime in Juggler: %s' % e.message)
