# -*- coding: utf-8 -*-
import json

from tornado.gen import coroutine
from tornado.web import Finish

from .base import BaseHandler
from ..utils.logger import logger


class TelegramHandler(BaseHandler):

    def initialize(self):
        """
        You could pass some variables to this method when
        creating ``handlers`` in `disk.admin.conductor.sync.scripts.main:create_app`
        """

    @coroutine
    def post(self):
        try:
            token = self.request.headers.get('TGBotToken')
            if not token:
                message = 'Unauthorized request for TelegramHandler'
                logger.error(message)
                self.write_error(403, message=message)
                raise Finish()

            try:
                package = json.loads(self.request.body)
                logger.debug(package)

            except Exception as e:
                message = 'Unable to parse JSON from body => %s' % e.message
                logger.error(message)
                self.write_error(400, message=message)
                raise Finish()

            message = package.get('text')
            if not message:
                message = 'Malformed JSON body received. Is there is a notification?'
                logger.critical(message)
                self.write_error(400, message=message)
                raise Finish()

            response = yield self.application.telegram_api.send_message(
                message, chat_id=package.get('chat_id'), token=token
            )
            self.response(response, encode=False)
        except Finish:
            pass

        except Exception as e:
            logger.error('Unhandled exception in main TelegramHandler: %s' % e.message)
            self.write_error(500)

        finally:
            self.finish()
