# -*- coding: utf-8 -*-
"""
    Logging settings which are using colored logs package.
"""
import logging

CONSOLE_LOGGING = {
    'version': 1,
    'formatters': {
        'tskv': {
            'format': "tskv\ttskv_format=ydisk-conductor-sync\tname=%(name)s\tunixtime=%(created)d\t"
                      "timestamp=%(asctime)s\ttimezone=+0300\tpid=%(process)s\tmodule=%(module)s\t"
                      "environment_id=%(environment_id)s\tlevel=%(levelname)s\tmessage=%(message)s"
        }
    },
    'handlers': {
        'default': {
            'formatter': 'tskv',
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
        },
    },
    'loggers': {
        'conductor-sync': {
            'handlers': ['default'],
            'level': 'DEBUG',
            'propagate': False
        }
    }
}


def tskv_escape(message):
    return (
        message
        .replace('\\', '\\\\')
        .replace('\t', r'\t')
        .replace('\r', r'\r')
        .replace('\n', r'\n')
        .replace('\0', r'\0')
    )


class EnvironmentLogger(logging.LoggerAdapter):
    def __init__(self, environment_id='None', environment_status='None'):
        super(EnvironmentLogger, self).__init__(
            logging.getLogger('conductor-sync'),
            {'environment_id': environment_id, 'status': environment_status},
        )

    def process(self, message, *args, **kwargs):
        return super(EnvironmentLogger, self).process(tskv_escape(unicode(message)), *args, **kwargs)


logger = EnvironmentLogger()
