# -*- coding: utf-8 -*-
from tornado import ioloop
from tornado.gen import Return, coroutine, sleep


def shorten_ipv6(ipv6_long):
    hextets = ['%x' % int(h, 16) for h in ipv6_long.split(':')]
    best_doublecolon_start = -1
    best_doublecolon_len = 0
    doublecolon_start = -1
    doublecolon_len = 0
    for index, hextet in enumerate(hextets):
        if hextet == '0':
            doublecolon_len += 1
            if doublecolon_start == -1:
                # Start of a sequence of zeros.
                doublecolon_start = index
            if doublecolon_len > best_doublecolon_len:
                # This is the longest sequence of zeros so far.
                best_doublecolon_len = doublecolon_len
                best_doublecolon_start = doublecolon_start
        else:
            doublecolon_len = 0
            doublecolon_start = -1
    if best_doublecolon_len > 1:
        best_doublecolon_end = (best_doublecolon_start +
                                best_doublecolon_len)
        # For zeros at the end of the address.
        if best_doublecolon_end == len(hextets):
            hextets += ['']
        hextets[best_doublecolon_start:best_doublecolon_end] = ['']
        # For zeros at the beginning of the address.
        if best_doublecolon_start == 0:
            hextets = [''] + hextets
    return ':'.join(hextets)


@coroutine
def with_retry(func, args, tries=3, timeout=3):
    response = None
    for i in range(tries):
        response = yield func(*args)
        if response is not None:
            break
        yield sleep(timeout)
    raise Return(response)


def apply_async(func, *args):
    ioloop.IOLoop.current().spawn_callback(func, *args)
