#!/usr/bin/python

import yaml
import json
import requests
import requests.exceptions
from time import sleep
from library.python import resource

URL = 'https://conductor-sync.qloud.disk.yandex.net/deploy/'
HEADERS = {'Content-Type': 'application/json'}


def main():
    config_file = resource.find("config")
    config = yaml.safe_load(config_file)

    for cluster in config['deploy_clusters']:
        data = {'stage': cluster}
        print(cluster)
        tries = 0
        while tries < 3:
            tries = tries + 1
            try:
                print('Try ', tries)
                result = requests.post(URL, data=json.dumps(data), headers=HEADERS)
            except requests.exceptions.RequestException as e:
                print('Got exception:', e)
            else:
                print(result)
                break
        sleep(2)

if __name__ == '__main__':
    main()
