# -*- coding: utf-8 -*-
import json

import requests
from getip import settings

from .logger import logger


def conductor_api_call(method, param):
    res = requests.get(
        settings.CONDUCTOR_API_URL.format(method=method, param=param)
    )

    if not 200 <= res.status_code <= 300:
        logger.error(
            'Failed to request <white>{method}</white> => <white>{param}</white> '
            'code => <red>{code}</red> reason => <yellow>{reason}</yellow>'.format(
                method=method, param=param, code=res.status_code, reason=res.reason
            )
        )

    try:
        return json.loads(res.content)
    except Exception:
        return []
