#!/bin/bash

function check_result {
  if [ $1 -ne 0 ]; then
    echo "##teamcity[testFailed name='docker.common.$2']"
    return 1
  else
    return 0
  fi
}

"$(dirname "$0")"/login_docker.sh

path_prefix=disk/common
pushd $path_prefix

function build_one_common {
  dockerfile=$1
  distro=$(basename -s .Dockerfile $dockerfile)
  echo "##teamcity[testStarted name='docker.common.$distro']"

  # add NodeJS 14 for front
  if [ "$dockerfile" = "bionic-front.Dockerfile" ]; then
    wget -O node14.tgz http://s3.mds.yandex.net/sandbox-469/2127600291/node.tar.gz
    mkdir -p front-common-settings/opt/nodejs/14
    tar xzf node14.tgz -C front-common-settings/opt/nodejs/14
    rm node14.tgz
  fi

  # rebuild and push
  docker build --pull -f ${dockerfile} -t registry.yandex.net/$path_prefix/${distro}:latest .
  check_result $? "$distro" || exit 1
  docker push registry.yandex.net/$path_prefix/${distro}:latest
  check_result $? "$distro" || exit 1
  echo "##teamcity[testFinished name='docker.common.$distro']"
}

# rebuild common images after base distros
for dockerfile in *.Dockerfile; do
  build_one_common $dockerfile &
done

wait
popd

curl -X POST "https://testenv.yandex-team.ru/api/te/v1.0/projects/disk-docker/jobs/BUILD_DISK_DOCKER_IMAGE_CLUSTERS/runs" \
     -H "accept: application/json" \
     -H "Content-Type: application/json" \
     -H "Authorization: OAuth ${TESTENV_TOKEN}" \
     -d "{ \"revisions\": [ \"${CURRENT_REVISION}\" ]}"
