#!/bin/bash

function check_result {
  if [ $1 -ne 0 ]; then
    echo "##teamcity[testFailed name='docker.distro.$2']"
    return 1
  else
    return 0
  fi
}

"$(dirname "$0")"/login_docker.sh

path_prefix=disk/distro
pushd $path_prefix
# rebuild distro images
for dockerfile in *.Dockerfile; do
  distro=$(basename -s .Dockerfile $dockerfile)
  echo "##teamcity[testStarted name='docker.distro.$distro']"
  # rebuild and push
  docker build --pull -f ${dockerfile} -t registry.yandex.net/$path_prefix/${distro}:latest .
  check_result $? "$distro" || exit 1
  docker push registry.yandex.net/$path_prefix/${distro}:latest
  check_result $? "$distro" || exit 1
  echo "##teamcity[testFinished name='docker.distro.$distro']"
done
popd

curl -X POST "https://testenv.yandex-team.ru/api/te/v1.0/projects/disk-docker/jobs/BUILD_DISK_DOCKER_IMAGE_COMMON/runs" \
     -H "accept: application/json" \
     -H "Content-Type: application/json" \
     -H "Authorization: OAuth ${TESTENV_TOKEN}" \
     -d "{ \"revisions\": [ \"${CURRENT_REVISION}\" ]}"
