#!/bin/bash

cluster=${1:?usage: $0 <cluster_name> <tag>}
tag=${2:?usage: $0 <cluster_name> <tag>}

CWD=$(dirname $(realpath $0))

$CWD/login_docker.sh
path_prefix=disk/clusters/${cluster}
pushd $path_prefix
echo "##teamcity[testStarted name='docker.clusters.$cluster' captureStandardOutput='true']"

for package in OPSM QAPPROUTER; do
  version=$(grep "^ENV ${package}_VERSION" app.Dockerfile | awk '{print $(NF)}')
  if [ -n "$version" ]; then
    tag="${tag}_${package}-${version}"
  fi
done

function die {
  echo "##teamcity[testFailed name='docker.clusters.$cluster']"
  exit 1
}

function check_result {
  if [ $1 -ne 0 ]; then
    die
  else
    return 0
  fi
}

docker build --pull -f app.Dockerfile -t registry.yandex.net/${path_prefix}:${tag} . || die
docker push registry.yandex.net/${path_prefix}:${tag} || die
echo "##teamcity[testFinished name='docker.clusters.$cluster']"
popd

if [[ "$cluster" == "disk-office" || "$cluster" == "telemost-translator" ]]; then
  container_id=$(docker run --entrypoint hostname registry.yandex.net/${path_prefix}:${tag})
  docker export ${container_id} | gzip -c > ${cluster}.tar.gz
  svn export svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya
  ./ya upload \
    --attr=cluster=$cluster \
    --attr=revision=$tag \
    --description="$cluster porto layer" \
    --owner=DISK-ADMIN \
    --ttl=inf \
    --type=PORTO_LAYER \
    --json-output \
    ${cluster}.tar.gz
fi

