#!/usr/bin/python
import re
import sys
from collections import Counter, defaultdict

results = defaultdict(Counter)
task_re = re.compile("Task (?P<name>\w+)/(?P<guid>[0-9a-f\-]+) (?P<status>completed|failed)")

for line in sys.stdin:
    if line.strip() == '':
        continue

    if "INFO" not in line and "ERROR" not in line:
        continue

    line_matches = task_re.search(line)

    if line_matches:
        results[line_matches.group('name').replace('.', '_')][line_matches.group('status')] += 1
        results['total'][line_matches.group('status')] += 1

for task, statuses in results.items():
    for status in ("completed", "failed"):
        print("{}.{} {}".format(task, status, statuses[status]))
