#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import sys
from collections import Counter, defaultdict

clients_full_status = defaultdict(Counter)
clients_proxy_status = defaultdict(Counter)
clients_status = defaultdict(Counter)
clients_timings = defaultdict(Counter)
clients_not_proxy_status = defaultdict(Counter)
proxy_ycrids = defaultdict(set)


def parse_tskv_field(tskv, field_name):
    field = '\t' + field_name + '='
    index = tskv.find(field)
    return tskv[index + len(field):].split('\t')[0]


def print_timings(name, data):
    for client, timings in sorted(data.items()):
        if timings:
            packed_timings = map(lambda t: "%s@%s" % t, sorted(timings.items()))
            print("@{}_{} {}".format(name, client, ' '.join(packed_timings)))


def print_counter(name, data):
    for client, counter in sorted(data.items()):
        for key, val in sorted(counter.items()):
            if name:
                print("{}_{}_{} {}".format(name, client, key, val))
            else:
                print("{}_{} {}".format(client, key, val))


for line in sys.stdin:
    if not line.strip():
        continue

    client_id = parse_tskv_field(line, 'client_id')
    if client_id == '-':
        client_id = None
    status = parse_tskv_field(line, 'status')[0] + 'xx'
    request_time = parse_tskv_field(line, 'request_time')
    request = parse_tskv_field(line, 'request')
    headers = parse_tskv_field(line, 'headers')
    ycrid = parse_tskv_field(line, 'ycrid')

    clients_full_status[client_id][status] += 1
    clients_status[client_id][status] += 1

    if 'x-skipproxy' in headers.lower():
        if ycrid not in proxy_ycrids[client_id]:
            clients_status[client_id][status] -= 1
            proxy_ycrids[client_id].add(ycrid)
        clients_proxy_status[client_id][status] += 1
    else:
        clients_timings[client_id][request_time] += 1
        clients_not_proxy_status[client_id][status] += 1

print_counter('full', clients_full_status)
print_counter('proxy', clients_proxy_status)
print_counter('not_proxy', clients_not_proxy_status)
print_counter('', clients_status)
print_timings('timings', clients_timings)
