#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Хук перехватывает команды task do и task preinstall (для остальных ничего не делает) и перед их выполнением проверяет
работоспособность хостов, на которые будет раскатан пакет. Если хоть один хост недоступен, то
скрипт отработает со статус кодом > 0.
"""

import os
import subprocess
import sys


PACKAGES_MONITORING_DIRECTORY = '/var/cache/disk_deploy'
EXECUTER_COMMAND = 'executer --quiet -u ${SSH_USER:-root} -c'


class bcolors(object):
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'


def find_conductor_groups_and_package_for_installation(ticket_number, dc=None):
    """Найти кондукторные группы, на которые будут раскатываться пакеты из тикета."""
    print
    print bcolors.OKBLUE + 'Parsing ticket «%s» for conductor groups and packages...' % ticket_number + bcolors.ENDC
    output = subprocess.check_output(
        "%s 'task list %s'" % (EXECUTER_COMMAND, ticket_number),
        shell=True,
        stderr=subprocess.STDOUT
    )
    lines = output.split('\n')
    lines = [l.strip() for l in lines]
    conductor_groups = ''
    package = ''
    for line in lines:
        if line.startswith('Install: '):
            conductor_groups = line.replace('Install: ', '', 1)
        elif line.startswith('python-mpfs-api='):
            package, _ = line.split()
        elif line.startswith('python-mpfs-disk='):
            package, _ = line.split()
        elif line.startswith('python-mpfs-queue='):
            package, _ = line.split()

    if not all((conductor_groups, package)):
        print bcolors.FAIL + 'Could not find conductor groups or installed package in ticket.' + bcolors.ENDC
        exit(1)

    print bcolors.OKBLUE + 'Ticket parsed.' + bcolors.ENDC
    print bcolors.OKBLUE + 'Conductor groups: %s' % conductor_groups + bcolors.ENDC
    print bcolors.OKBLUE + 'Installed package: %s' % package + bcolors.ENDC

    if dc is not None:
        conductor_groups = ','.join(g + dc for g in conductor_groups.split(','))

    return conductor_groups, package


def find_error_hosts(output):
    """Проверить вывод на наличие ошибок.

    Возвращает список хостов, на которых были обнаружены ошибки.
    """
    lines = filter(None, [l.strip() for l in output.split('\n')])
    if lines[-1].startswith('Error'):
        hosts = lines[-1].split()[-1].split(',')
        return hosts
    return []


def check_alive_groups(conductor_groups):
    """Проверить что хосты работоспособны."""
    print bcolors.OKBLUE + 'Checking hosts reachability for conductor groups %s:' % conductor_groups + bcolors.ENDC
    output = subprocess.check_output(
        "%s 'p_exec %s uptime'" % (EXECUTER_COMMAND, conductor_groups),
        shell=True,
        stderr=subprocess.STDOUT
    )
    print output
    return find_error_hosts(output)


def create_packages_monitoring_directory(ticket_number, dc=None):
    conductor_groups, package = find_conductor_groups_and_package_for_installation(ticket_number, dc=dc)
    subprocess.call(
        "%s 'p_exec %s sudo mkdir -p %s'" % (EXECUTER_COMMAND, conductor_groups, PACKAGES_MONITORING_DIRECTORY),
        shell=True,
        stderr=subprocess.STDOUT
    )
    return conductor_groups, package


def parse_package(package):
    """Возвращает имя пакета и его версию."""
    return package.split('=')


def write_currently_installing_package(conductor_groups, package):
    package, version = parse_package(package)
    version = version.replace('-', '.')
    subprocess.call(
        "%s 'p_exec %s sudo sh -c \"echo %s > %s\"'" % (
            EXECUTER_COMMAND,
            conductor_groups,
            version,
            os.path.join(PACKAGES_MONITORING_DIRECTORY, '%s.txt' % package)
        ),
        shell=True,
        stderr=subprocess.STDOUT
    )


def reset_apt_get_cache(conductor_groups):
    apt_cache_reset_command = (
        'sudo find /var/lib/apt/lists -type f -delete && sudo apt-get clean && sudo apt-get update -qq')
    subprocess.call(
        "%s 'p_exec %s %s'" % (
            EXECUTER_COMMAND,
            conductor_groups,
            apt_cache_reset_command,
        ),
        shell=True,
        stderr=subprocess.STDOUT
    )


def main():
    # просто выполнили команду task
    if __name__ == '__main__':
        if len(sys.argv) == 1:
            exit(0)
        else:
            # task ...
            if len(sys.argv) == 2:
                # task sub_command
                exit(0)

            # task sub_command ...
            sub_command = sys.argv[1]
            if sub_command not in ('preinstall', 'do'):
                exit(0)

            # task preinstall ... or task do ...
            ticket_number = sys.argv[-1]
            dc = sys.argv[2] if sys.argv[2].startswith('@') else None

            conductor_groups, package = create_packages_monitoring_directory(ticket_number, dc=dc)
            write_currently_installing_package(conductor_groups, package)
            reset_apt_get_cache(conductor_groups)


if __name__ == '__main__':
    main()
