# processes /var/log/nginx/docfront/access-nodejs-tskv.log

@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  codes["2xx"] = 0
  codes["3xx"] = 0
  codes["4xx"] = 0
  codes["5xx"] = 0
}


# skip service uris
/request=\/ping/ {
  next
}
/request=\/timetail/ {
  next
}
/request=\/container_status_hook/ {
  next
}
/request=\/exec_pattern/ {
  next
}

# capture status codes
match($0, /status=([0-9])[0-9][0-9]/, capture) {
  codes[capture[1] "xx"]++
}

# capture timings
match($0, /request_time=([0-9]+\.[0-9]+)/, capture) {
  timing_name = capture[1]

  if (match($0, /request=\/view\/[0-9]+\/(source|htmlimage)/, _)) {
    proxies_timings[timing_name]++
  } else if (match($0, /request=\/api\//)) {
    api_timings[timing_name]++
  } else if (!match($0, /request=\/(monitoring.txt|ping)/)) {
    pages_timings[timing_name]++
  }

  all_timings[timing_name]++
}


END {
  print_graph("docfront_codes", codes)
  print_timing_graph("docfront_all_timings", all_timings)
  print_timing_graph("docfront_proxies_timings", proxies_timings)
  print_timing_graph("docfront_api_timings", api_timings)
  print_timing_graph("docfront_pages_timings", pages_timings)
}
