#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import sys
from collections import defaultdict, Counter

actions = Counter()
log_message_to_request_type = {
    'failed. took': 'failed',
    'cannot acquire session from pool': 'session_problem',
    'queue is full': 'queue_full',
    'No current transaction': 'no_current_transaction',
    'Can\'t rollback transaction': 'rollback_error',
    'Transaction locks invalidated': 'transaction_locks_invalidated',
    'gRPC error: (UNAVAILABLE) Network closed for unknown reason': 'network_error',
    'Cannot execute data query, code: UNDETERMINED': 'undetermined_error',
    'Can\'t begin transaction session, code: BAD_SESSION': 'bad_session',
    'pool was closed': 'closed_pool',
}


def parse_tskv_field(tskv, field_name):
    field = '\t' + field_name + '='
    index = tskv.find(field)
    return tskv[index + len(field):].split('\t')[0]


def print_counter(counter):
    for k, v in counter.items():
        print("%s %d" % (k, v))


lines = sys.stdin
for line in lines:
    if not line.strip():
        continue

    class_field = parse_tskv_field(line, 'class')
    message = parse_tskv_field(line, 'message')
    if class_field and 'TwinDaoInvocationHandler' in class_field and message:
        if 'took' in message and 'failed. took' not in message:
            actions['success'] += 1

        for log_message, yasm_metric in log_message_to_request_type.items():
            if log_message in message:
                actions[yasm_metric] += 1

print_counter(actions)
