#!/usr/bin/env python

# -*- coding: UTF-8 -*-
import sys
from collections import defaultdict, Counter


actions = Counter()
log_message_to_request_type = {
    'Both executors full, returning fallback result': 'fallback_executors_full',
    'Returning fast main result': 'main_fast',
    'Returning fast fallback result': 'fallback_fast',
    'Returning slow fallback result': 'fallback_slow',
    'Returning slow main result': 'main_slow',
}

def print_counter(counter):
    for k, v in counter.items():
        print("%s %d" % (k, v))


def parse_tskv_field(tskv, field_name):
    field = '\t' + field_name + '='
    index = tskv.find(field)
    return tskv[index + len(field):].split('\t')[0]


lines = sys.stdin
for line in lines:
    if not line.strip():
        continue

    class_field = parse_tskv_field(line, 'class')
    message = parse_tskv_field(line, 'message')
    if class_field and 'TwinDaoInvocationHandler' in class_field and message:
        for log_message, yasm_metric in log_message_to_request_type.items():
            if log_message in message:
                actions[yasm_metric] += 1

print_counter(actions)
