#!/usr/bin/env python
import re
import sys
import httplib
from collections import defaultdict

meters_urls = {
    'time_lag' : ['GET', '/m/my/ls/local/production/disk/event-loader/*/*/*/*/event-loader/log-processing/eventTimeLagThresholds_distribution/1_min'],
}

results_sensors = defaultdict(int)

regex_report = re.compile(r"{ 40sec: (?P<sec40>\d+\.\d+)% 7min: (?P<min7>\d+\.\d+)% 15min: (?P<min15>\d+\.\d+)% (?:other: (?P<other>\d+\.\d+)% )?30min: (?P<min30>\d+\.\d+)% 1min: (?P<min1>\d+\.\d+)% 3min: (?P<min3>\d+\.\d+)% 20sec: (?P<sec20>\d+\.\d+)% }\[sum = (?P<sum>\d+\.\d+)\]")

#collect
conn = httplib.HTTPConnection('127.0.0.1', 29705)
for url in meters_urls:
    conn.request(meters_urls[url][0], meters_urls[url][1])
    for m in regex_report.finditer(conn.getresponse().read()):
        results_sensors.update(m.groupdict())

conn.close()

for k, v in results_sensors.items():
    if v is None:
        results_sensors[k] = '0.0'

for sensor, value in sorted(results_sensors.items()):
    print("history_lag_%s %s" % (sensor, value))

sys.exit(0)
