# processes /var/log/nginx/access-tskv.log

@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  total_rps = 0
  error_pages = 0
  upload_errors = 0
}

# skip tech handlers
/request=\/ping/ {
  next
}
/request=\/timetail/ {
  next
}
/request=\/container_status_hook/ {
  next
}
/request=\/exec_pattern/ {
  next
}
/request=\/unistat_stub_status/ {
  next
}
/request=\/stats\/video-player/ {
  next
}

/request=\/monitoring\.txt\?event=errorPage&/ {
  error_pages++
}
/request=\/monitoring\.txt\?event=uploadError&/ {
  upload_errors++
}
/request=\/monitoring.txt/ {
  next
}

# capture status codes
match($0, /status=([0-9])[0-9]{2}/, capture) {
  total_rps++

  code = capture[1] "xx"
  codes[code]++

  # log "2xx per domain"
  if (code == "2xx") {
    match($0, /vhost=([^ \t:]+)/, host_capture)
    hostname = host_capture[1]
    gsub(/\./, "_", hostname)
    code_2xx_by_domains[hostname]++
  }

  if (match($0, /request=\/models/)) {
    models_codes[code]++
  } else {
    other_codes[code]++
  }
}

# capture timings
match($0, /request_time=([0-9]+\.[0-9]+)/, capture) {
  timing = capture[1]

  all_timings[timing]++

  if (match($0, /request=\/models/)) {
    models_timings[timing]++
  } else {
    other_timings[timing]++
  }
}
match($0, /upstream_response_time=([0-9]+\.[0-9]+)/, capture) {
  upstream_timings[capture[1]]++
}

END {
  print "ufo_client_total_rps", total_rps
  print "ufo_client_error_pages", error_pages
  print "ufo_client_upload_errors", upload_errors

  print_graph("ufo_client_2xx_per_domain", code_2xx_by_domains)
  print_graph("ufo_client_codes", codes)
  print_graph("ufo_client_models_codes", models_codes)
  print_graph("ufo_client_other_codes", other_codes)

  print_timing_graph("ufo_client_all_timings", all_timings)
  print_timing_graph("ufo_client_models_timings", models_timings)
  print_timing_graph("ufo_client_other_timings", other_timings)
  print_timing_graph("ufo_client_upstream_timings", upstream_timings)
}
