# processes NODE_LOG_DIR/yandex-disk-notes-tskv.log

@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  # backend_components - список компонент, для которых надо логировать тайминги
  backend_components["middleware/auth"] = 1
  backend_components["uaas"] = 1
  backend_components["intapi"] = 1

  for (component in backend_components) {
    codes[component]["2xx"] = 0
    codes[component]["3xx"] = 0
    codes[component]["4xx"] = 0
    codes[component]["5xx"] = 0
  }
}

# capture errors by component
/level=error/ {
  match($0, /component=([^\t]+)/, capture)

  if (capture[1] == "middleware/auth") {
    errors_by_component["blackbox"]++
  } else {
    errors_by_component[capture[1]]++
  }
}

# capture all timings
match($0, /component=([^\t]+)/, capture) {
  component = capture[1]
  if (component in backend_components) {
    if (match($0, /\ttime=([0-9]+)/, capture)) {
      timings[component][capture[1]]++
    }
    if (match($0, /\tstatusCode=([0-9])[0-9][0-9]/, capture)) {
      codes[component][capture[1] "xx"]++
    }
  }

}

END {
  print_graph("ufo_notes_errors_by_component", errors_by_component)
  print_timing_graph("ufo_notes_blackbox_timings", timings["middleware/auth"])
  print_timing_graph("ufo_notes_uaas_timings", timings["uaas"])
  print_timing_graph("ufo_notes_intapi_timings", timings["intapi"])

  print_graph("ufo_notes_blackbox_codes", codes["middleware/auth"])
  print_graph("ufo_notes_uaas_codes", codes["uaas"])
  print_graph("ufo_notes_intapi_codes", codes["intapi"])
}
