function print_timing_graph(name, items) {
  if (length(items)) {
    printf "@%s ", name
    for (item in items) {
      printf " " item "@" items[item]
    }
    printf "\n"
  }
}

function print_graph(name, items) {
  for (item in items) {
    print name "." item, items[item]
  }
}

BEGIN {
  codes["2xx"] = 0
  codes["3xx"] = 0
  codes["4xx"] = 0
  codes["5xx"] = 0
}

# skip tech handlers
/request=\/ping/ {
  next
}
/request=\/timetail/ {
  next
}
/request=\/container_status_hook/ {
  next
}
/request=\/exec_pattern/ {
  next
}
/request=\/unistat_stub_status/ {
  next
}

# capture status codes
match($0, /status=([0-9])[0-9][0-9]/, capture) {
  codes[capture[1] "xx"]++
}

# capture timings
match($0, /request_time=([0-9]+\.[0-9]+)/, capture) {
  all_timings[capture[1]]++
}

END {
  print_graph("ufo_promo_codes", codes)
  print_timing_graph("ufo_promo_all_timings", all_timings)
}
