# processes /var/log/nginx/access-tskv.log

@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  codes["2xx"] = 0
  codes["3xx"] = 0
  codes["4xx"] = 0
  codes["5xx"] = 0

  save_codes["2xx"] = 0
  save_codes["3xx"] = 0
  save_codes["4xx"] = 0
  save_codes["5xx"] = 0

  error_pages = 0
}

# skip tech handlers
/request=\/ping/ {
  next
}
/request=\/timetail/ {
  next
}
/request=\/container_status_hook/ {
  next
}
/request=\/exec_pattern/ {
  next
}
/request=\/unistat_stub_status/ {
  next
}

/request=\/public\/monitoring\.txt\/?\?event=errorPage&/ {
  error_pages++
}

# capture status codes
match($0, /status=([0-9])[0-9][0-9]/, capture) {
  codes[capture[1] "xx"]++

  if (match($0, /request=\/public\/api\/save/)) {
    save_codes[capture[1] "xx"]++
  }
}

# capture timings
match($0, /request_time=([0-9]+\.[0-9]+)/, capture) {
  timing_name = capture[1]

  if (match($0, /request=\/public\/api\/check-auth/)) {
    auth_timings[timing_name]++
  } else if (match($0, /request=\/public\/api\/save/)) {
    save_timings[timing_name]++
  } else if (match($0, /request=\/public\/api\//)) {
    api_timings[timing_name]++
  } else if (match($0, /request=\/(public|mail|i|d)/)) {
    page_timings[timing_name]++
  }

  all_timings[timing_name]++
}


END {
  printf "error_pages " error_pages "\n"
  print_graph("ufo_public_codes", codes)
  print_graph("ufo_public_save_codes", save_codes)
  print_timing_graph("ufo_public_all_timings", all_timings)
  print_timing_graph("ufo_public_auth_timings", auth_timings)
  print_timing_graph("ufo_public_save_timings", save_timings)
  print_timing_graph("ufo_public_page_timings", page_timings)
  print_timing_graph("ufo_public_api_timings", api_timings)
}
