# processes NODE_LOG_DIR/yandex-disk-public-tskv.log

@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  # backend_components - список компонент, для которых надо логировать тайминги
  backend_components["mpfs"] = 1
  backend_components["intapi"] = 1
  backend_components["middleware/auth"] = 1
  backend_components["clicker"] = 1
  backend_components["uaas"] = 1
  backend_components["directory-api"] = 1

  for (component in backend_components) {
    codes[component]["2xx"] = 0
    codes[component]["3xx"] = 0
    codes[component]["4xx"] = 0
    codes[component]["5xx"] = 0
  }
}

# capture errors by component
/level=error/ {
  match($0, /component=([^\t]+)/, capture)

  if (capture[1] == "middleware/auth") {
    errors_by_component["blackbox"]++
  } else {
    errors_by_component[capture[1]]++
  }
}

# capture all mpfs, intapi, blackbox and clicker timings
match($0, /component=([^\t]+)/, capture) {
  component = capture[1]

  if (component in backend_components) {
    if (match($0, /\ttime=([0-9]+)/, capture)) {
      timings[component][capture[1]]++
    }
    if (match($0, /\tstatusCode=([0-9])[0-9][0-9]/, capture)) {
      codes[component][capture[1] "xx"]++
    }
  }
}

END {
  print_graph("ufo_public_errors_by_component", errors_by_component)
  print_timing_graph("ufo_public_mpfs_timings", timings["mpfs"])
  print_timing_graph("ufo_public_intapi_timings", timings["intapi"])
  print_timing_graph("ufo_public_blackbox_timings", timings["middleware/auth"])
  print_timing_graph("ufo_public_clicker_timings", timings["clicker"])
  print_timing_graph("ufo_public_uaas_timings", timings["uaas"])
  print_timing_graph("ufo_public_directory-api_timings", timings["uaas"])

  print_graph("ufo_public_mpfs_codes", codes["mpfs"])
  print_graph("ufo_public_intapi_codes", codes["intapi"])
  print_graph("ufo_public_blackbox_codes", codes["middleware/auth"])
  print_graph("ufo_public_clicker_codes", codes["clicker"])
  print_graph("ufo_public_uaas_codes", codes["uaas"])
  print_graph("ufo_public_directory-api_codes", codes["directory-api"])
}
