@include "/usr/bin/monitoring/common-functions.awk"

BEGIN {
  # backend_components - список компонент, для которых надо логировать тайминги
  backend_components["passport"] = 1
  backend_components["mpfs"] = 1
  backend_components["node"] = 1
  backend_components["tvm"] = 1

  for (component in backend_components) {
    codes[component]["2xx"] = 0
    codes[component]["3xx"] = 0
    codes[component]["4xx"] = 0
    codes[component]["5xx"] = 0
  }
}

# capture errors by component
/level=error/ {
  match($0, /component=([^\t\/]+)/, capture)
  errors_by_component[capture[1]]++
}

# capture all timings
match($0, /component=([^\t\/]+)/, capture) {
  component = capture[1]
  if (component in backend_components) {
    if (match($0, /\trequest_time=([0-9]+)/, capture)) {
      timings[component][capture[1]]++
    }
    if (match($0, /\tstatus=([0-9])[0-9][0-9]/, capture)) {
      codes[component][capture[1] "xx"]++
    }
  }
}

END {
  print_graph("ufo_widget_errors_by_component", errors_by_component)
  print_timing_graph("ufo_widget_passport_timings", timings["passport"])
  print_timing_graph("ufo_widget_mpfs_timings", timings["mpfs"])
  print_timing_graph("ufo_widget_node_timings", timings["node"])
  print_timing_graph("ufo_widget_tvm_timings", timings["tvm"])

  print_graph("ufo_widget_passport_codes", codes["passport"])
  print_graph("ufo_widget_mpfs_codes", codes["mpfs"])
  print_graph("ufo_widget_node_codes", codes["node"])
  print_graph("ufo_widget_tvm_codes", codes["tvm"])
}
