#!/usr/bin/python
import requests

CA_FILE = '/usr/local/share/ca-certificates/YandexInternalRootCA.crt'
PW_FILE = '/usr/local/etc/logshatter_cleaner.conf'

ch_host = 'ch01h.disk.yandex.net'
ch_db = 'logs'
ch_cluster = 'logshattercluster'

log_tables_query = 'SELECT name FROM system.tables WHERE database = \'logs\' AND engine = \'ReplicatedMergeTree\''
clear_old_data_query = 'ALTER TABLE {} ON CLUSTER {} DELETE WHERE date < (today() - 3)'

with open(PW_FILE) as f:
    CH_USER, CH_PASSWORD = f.readline().rstrip().split(':')

def ch_request(host, db, query, method='get'):
    url = 'https://{host}:8443/?database={db}&query={query}'.format(
        host=host,
        db=db,
        query=requests.utils.quote(query))
    auth = {
        'X-ClickHouse-User': CH_USER,
        'X-ClickHouse-Key': CH_PASSWORD,
    }

    if method == 'post':
        do_request = requests.post
    else:
        do_request = requests.get

    res = do_request(
        url,
        headers=auth,
        verify=CA_FILE)
    res.raise_for_status()

    return res.text.rstrip().split('\n')


if __name__ == "__main__":
    for table in ch_request(ch_host, ch_db, log_tables_query):
        print '*** {} ***'.format(table)
        cleardb_query = clear_old_data_query.format(table, ch_cluster)
        print ch_request(ch_host, ch_db, cleardb_query, 'post')
