#!/bin/bash

#
# uwsgi watchdog
#

STABLE_TIME=120
PING_PATTERN="pong"
CURL_TIMEOUT=10

if [[ -f /maintenance.lock ]]; then
  echo "file /maintenance.lock found, exiting"
  exit 0
fi

if ! supervisorctl status backend | grep -q "RUNNING"; then
  echo "backend is not in RUNNING state, exiting"
  exit 0
fi

BACKEND_PID=$(supervisorctl pid backend)
BACKEND_UPTIME=$(ps -o etimes= -p "$BACKEND_PID")

if [ "$BACKEND_UPTIME" -gt "$STABLE_TIME" ]; then
  if ! curl -m "$CURL_TIMEOUT" -s 'http://127.0.0.1/json/ping' | grep -q "$PING_PATTERN"; then
    echo "restarting backend" 
    supervisorctl restart backend
    echo "mpfs-core-uwsgi-disk restarted"
  fi
else
  echo "backend is running less than $STABLE_TIME seconds, exiting"
fi
