#!/bin/bash

ipset=$(which ipset)
ip6tables=$(which ip6tables)
CFG="/etc/yandex/pingunoque/config.yaml"
table_v6=$(fgrep 'set_v6:' "$CFG" | cut -f2 -d':' | tr -d ' ')

closed_ports=$(fgrep 'closed_ports' "$CFG" | cut -f2 -d':' | tr -d ' ')
if [[ -z $closed_ports ]]; then
    closed_ports=27017,27018,27019
fi

rule6=(OUTPUT -p tcp -m set --match-set down6 dst -m multiport --ports $closed_ports -j REJECT --reject-with tcp-reset)

$ipset list "$table_v6" &> /dev/null || $ipset create "$table_v6" hash:ip family inet6
$ip6tables -C "${rule6[@]}" >/dev/null 2>&1 || $ip6tables -A "${rule6[@]}"

exec /usr/bin/pingunoque
