#!/usr/bin/env python

import re
import sys
from collections import Counter

exception_re = re.compile(r'([A-Z][A-Za-z0-9_]+)(:|\\n$)')
service_group = sys.argv[1]
results_count_exceptions = Counter()
results_aggr_count_exceptions = 0

for line in sys.stdin:
    if not line.strip():
        continue

    message_index = line.find('\tmessage=')
    if message_index < 0:
        continue
    message = line[message_index + 9:].split('\t')[0]

    if not message.startswith('Traceback'):
        continue

    raise_index = message.find('raise')
    if raise_index < 0:
        continue

    message = message[raise_index:]
    exception_re_found = exception_re.search(message)
    if not exception_re_found:
        continue

    exception_name = exception_re_found.group(1)
    results_count_exceptions[exception_name] += 1
    results_aggr_count_exceptions += 1


for exception_name, exception_value in results_count_exceptions.iteritems():
    print('exception_count_{} {}'.format(exception_name, exception_value))

print('exception_aggr_count_Total {}'.format(results_aggr_count_exceptions))
print('exception_group_count_{}_Total {}'.format(service_group, results_aggr_count_exceptions))
