#!/usr/bin/python
import sys
import urllib2
import argparse
from urllib import urlencode


LB_DC_LIST = ('sas', 'iva', 'vla')
LB_PORT = 8999


def die(status=0, desc='OK'):
    print('%s;%s' % (status, desc))
    sys.exit(0)


def http_get(url, retries, req_timeout):
    for i in xrange(retries):
        try:
            http_req = urllib2.urlopen(url, timeout=req_timeout)
            if http_req.getcode() != 200:
                continue
            return http_req.read()
        except Exception:
            continue
    return False


parser = argparse.ArgumentParser()
parser.add_argument("--client", required=True)
parser.add_argument("--log-type", required=True, dest='log-type')
parser.add_argument("--threshold", required=True)
parser.add_argument("--ident")

args = parser.parse_args()

# getting args as dict
opts = vars(args)

# getting threshold from options list
threshold = int(opts.pop('threshold'))

partitions_with_lag = []
dc_with_no_data = []
desc = ''

# filtering unset parameters
opts = {k: v for k, v in opts.items() if v is not None}

for dc in LB_DC_LIST:
    opts['dc'] = dc
    query_opts = urlencode(opts)
    request_url = 'http://{}.logbroker.yandex.net:{}/pull/offsets?{}'.format(dc, LB_PORT, query_opts)
    lb_query_data = http_get(request_url, 2, 2.3)

    if lb_query_data:
        for line in lb_query_data.splitlines():
            topic_partition, offset, logstart, logsize, lag, owner = line.split('\t')
            lag = int(lag)
            if lag > threshold:
                partitions_with_lag.append((topic_partition, lag))
    else:
        dc_with_no_data.append(dc)

if partitions_with_lag:
    desc += 'Lag on {} partiton(s) is more than {}. '.format(len(partitions_with_lag), threshold)

if dc_with_no_data:
    desc += 'No LB lag info from {}.'.format(', '.join(dc_with_no_data))

if dc_with_no_data:
    die(2 if len(dc_with_no_data) > 1 else 1, desc)

if partitions_with_lag:
    die(2, desc)

die()
