#!/bin/bash

back="backend"
mapfile -t failed < <(supervisorctl status | grep -e 'Too many processes in process table' | awk '{print $1}')

if (( ${#failed[@]} > 0 )); then
    # Always restart backend as main processes locker
    supervisorctl restart $back
    for h in ${failed[@]}; do
        if [ $h != $back ]; then
            supervisorctl restart $h;
        fi
    done
    wait
else
    exit 1
fi
exit 0

