FROM registry.yandex.net/disk/common/office:latest

# Remove insecure plugins
RUN for plug in youtube speech glavred highlightcode macros ocr photoeditor translator; do \
        rm /var/www/r7-office/documentserver/sdkjs-plugins/$plug -rf; \
    done
RUN rm /var/www/r7-office/documentserver/server/FileConverter/bin/docbuilder

# Disable unlicensed system fonts
RUN rm -rf var/www/r7-office/documentserver/fonts/* \
        && rm -rf /var/www/r7-office/documentserver/sdkjs/common/AllFonts.js \
        && sed -i 's/--use-system="true"/--use-system="false"/' /usr/bin/documentserver-generate-allfonts.sh \
	# Disable supervisorctl restarts and nginx reload
	&& sed -i 's/supervisorctl restart/echo ignore supervisorctl restart/' /usr/bin/documentserver-generate-allfonts.sh \
	&& sed -i 's/service nginx reload/echo service nginx reload/' /usr/bin/documentserver-static-gzip.sh \
        && /bin/sh /usr/bin/documentserver-generate-allfonts.sh false \
	&& /bin/sh /usr/bin/documentserver-static-gzip.sh false 

# Fix security bug: https://stackoverflow.com/questions/43323754/cannot-make-remove-an-entry-for-the-specified-session-cron

# Preventive chown directories and disable chown inside base office layer <CHEMODAN-79159>
# Originally used in /docker/disk/clusters/disk-office/common-settings/app/ds/app/ds/run-document-server.sh

RUN for directory in \
        "postgres:postgres 700 /var/lib/postgresql" \
        "rabbitmq:rabbitmq go=rX,u=rwX /var/lib/rabbitmq" \
        "redis:redis 750 /var/lib/redis"; do \
                dir=$(echo $directory | awk '{print $3}'); \
                priv=$(echo $directory | awk '{print $2}'); \
                usr=$(echo $directory | awk '{print $1}'); \
                chown -R $usr $dir; \
                chmod -R $priv $dir; \
        done;

RUN echo "redeploy"

ADD common-settings/ /
# Emergency replacement for logo
RUN find ./ -name 'logo*.svg'  | xargs -I {} chown ds:ds {}

