#!/bin/bash

END_DATE=$(cat /var/www/r7-office/Data/license.lic | jq -r '.end_date')
END_DATE_TIMESTAMP=$(date --date="$END_DATE" +%s)
CURRENT_TIMESTAMP=$(date +%s)
DAY_DIFFERENCE=$(( (END_DATE_TIMESTAMP - CURRENT_TIMESTAMP) / (60*60*24) ))
LICENSE_ALERT=30

if [ $DAY_DIFFERENCE -lt $LICENSE_ALERT ]; then
    echo "2;Remain days: $DAY_DIFFERENCE"
else
    echo "0;License valid until $END_DATE"
fi
