#!/usr/bin/env python


def get_porto_num():
    try:
        with open('/.porto_num', 'r') as porto_num_file:
            return int(porto_num_file.read())
    except Exception:
        return None


def format(events):
    porto_num = get_porto_num()
    if not porto_num:
        return events

    instance_name = 'office%s' % porto_num

    for event in events:
        event['instance'] = instance_name
    return events
