#!/bin/bash

LOCK_FILE=/tmp/mqueue_watchdog

# kill processes and locks stuck longer than 10m
if test "`find $LOCK_FILE -mmin +10`"; then
        CPID=$$
        GID=`ps x -o  "%r %c" | grep -ve $CPID | grep -e 'mqueue_watch' | awk '{print $1}' | head -n 1`
        pkill -TERM -g "$GID" 2>/dev/null
        rm -f $LOCK_FILE
fi

# flock to prevent duplication of script
exec {lock_fd}>$LOCK_FILE || exit 1
flock -n "$lock_fd" || { echo "ERROR: flock() failed." >&2; exit 1; }

pid1_time=`date -d "$(ps -o lstart -p1 | tail -n 1)" +'%s'`
cur_time=`date +'%s'`
upstart_threshold=600

if (( (cur_time - pid1_time) < upstart_threshold )); then
        echo "pod started recently"
        exit 0
fi

# positive case
rabbitmq-diagnostics cluster_status --formatter json | jq ".listeners" | grep 'rabbit' && exit 0

# negative case
rabbitmq-diagnostics cluster_status 2>&1 | grep 'start the node' && service rabbitmq-server start && exit 0

exit 1

