#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import re
import sys
from collections import defaultdict, Counter

results_errors = { 'parse' : 0 }


results_count_codes = dict()
results_count_codes['total'] = Counter()
results_aggr_count_codes = dict()
results_aggr_count_codes['total'] = Counter()

results_timings = defaultdict(Counter)

# tskv	tskv_format=ydisk-ps-billing-web-requests-log	appname=ps-billing-web	host=sas2-9bbbe2c93f31.qloud-c.yandex.net	name=balance	unixtime=1580728837	timestamp=2020-02-03 14:20:37,399	timezone=+0300	ycrid=ps-billing-web-15494a281e91874c3fc9a36a1f555a17-sas2-9bbbe2c93f31	level=INFO	request_id=Emj2vSso	message=Method Balance2.GetClientContracts try #1 with params [{"ClientID":"71913929"}]: completed at https://balance-xmlrpc-tvm.paysys.yandex.net:8004/xmlrpctvm, with result [{"CURRENCY":"RUR","SERVICES":[202],"IS_ACTIVE":1,"IS_SIGNED":1,"IS_DEACTIVATED":0,"CONTRACT_TYPE":9,"PAYMENT_TYPE":3,"DT":1577307600000,"IS_CANCELLED":0,"OFFER_ACCEPTED":0,"MANAGER_CODE":21902,"PERSON_ID":9146961,"EXTERNAL_ID":"436921/19","IS_FAXED":0,"IS_SUSPENDED":0,"ID":1177117}]; took 196 ms
# Method Balance2.GetClientContracts try #1 with params [{"ClientID":"71913929"}]: completed at https://balance-xmlrpc-tvm.paysys.yandex.net:8004/xmlrpctvm, with result [{"CURRENCY":"RUR","SERVICES":[202],"IS_ACTIVE":1,"IS_SIGNED":1,"IS_DEACTIVATED":0,"CONTRACT_TYPE":9,"PAYMENT_TYPE":3,"DT":1577307600000,"IS_CANCELLED":0,"OFFER_ACCEPTED":0,"MANAGER_CODE":21902,"PERSON_ID":9146961,"EXTERNAL_ID":"436921/19","IS_FAXED":0,"IS_SUSPENDED":0,"ID":1177117}]; took 196 ms
BALANCE_REQ_TMPL = re.compile(r'\tname=balance\t?')
index_re = re.compile(
    'Method (?P<r_method>[\w.]+) try #\d with params [\w\W]+: (?P<r_status>completed|failed) at https?://.*, with result [\w\W]+; took (?P<r_took>[\d]+) ms')

for line in sys.stdin:
    if not BALANCE_REQ_TMPL.search(line):
        continue

    parts = line.strip("\n").split("\t")
    parsed = {}
    for part in parts:
        eq = part.find('=')
        key = part[:eq]
        value = part[(eq + 1):]
        parsed[key] = value


    matches = index_re.search(parsed['message'])
    if matches:
        r_method = matches.group('r_method')

        method = r_method.replace('.', '_')

        r_status = matches.group('r_status')
        r_took = str(int(matches.group('r_took')) / float(1000))

        if method not in results_count_codes:
            results_count_codes[method] = Counter()
        if method not in results_aggr_count_codes:
            results_aggr_count_codes[method] = Counter()

        results_timings[method][r_took] += 1
        results_timings['total'][r_took] += 1
        results_count_codes[method][r_status] += 1
        results_aggr_count_codes[method]['total'] += 1
        results_aggr_count_codes['total'][r_status] += 1
        results_aggr_count_codes['total']['total'] += 1

    else:
        results_errors['parse'] += 1
#        print line
        continue

# count_hosts_codes (codes per url)
for method, result in sorted(results_count_codes.iteritems()):
    for status_k, status_v in sorted (result.iteritems()):
        print("request_count_%s_%s %d" % (method, status_k, status_v))

print
# count_hosts_codes (codes per url)
for method, result in sorted(results_aggr_count_codes.iteritems()):
    for status_k, status_v in sorted(result.iteritems()):
        print("request_aggr_count_%s_%s %d" % (method, status_k, status_v))

print
for method, timings in sorted(results_timings.iteritems()):
    if timings:
        packed_timings = map(lambda t: "%s@%s" % t, sorted(timings.items()))
        print("@request_timings_%s %s" % (method, " ".join(packed_timings)))

for error, value in sorted(results_errors.iteritems()):
    print("error_%s %d" % (error, value))

sys.exit(0)
