#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import re
import sys
from collections import defaultdict, Counter

results_count_codes = Counter()
results_timings = defaultdict(Counter)

def parse_tskv_field(tskv, field_name):
    field = '\t' + field_name + '='
    index = tskv.find(field)
    return tskv[index + len(field):].split('\t')[0]

def metric_name(*args):
    return '_'.join(map(str, args))

def print_codes(name, counter):
    for k, v in counter.items():
        print("%s.%s %d" % (name, k, v))


def print_timings(name, input_timings):
    packed_timings = map(lambda t: "%s@%s" % t, sorted(input_timings.items()))
    if packed_timings:
        print("@%s %s" % (name, ' '.join(packed_timings)))

lines =  sys.stdin
for line in lines:
    if not line.strip():
        continue

    client = parse_tskv_field(line, 'client_id')
    if client == '-':
        client = None
    status = parse_tskv_field(line, 'status')
    status_group = status[0] + 'xx'
    request_time = parse_tskv_field(line, 'request_time')
    request = parse_tskv_field(line, 'request')

    results_count_codes[metric_name(client, status)] += 1
    results_count_codes[metric_name(client, status_group)] += 1
    results_count_codes[metric_name('total', status)] += 1
    results_count_codes[metric_name('total', status_group)] += 1

    results_timings[client][request_time] += 1


print_codes("client_request_count", results_count_codes)
for key, timings in results_timings.items():
    print_timings("client_request_timings.%s" % key, timings)
