#!/usr/bin/python
import re
import sys
from collections import Counter, defaultdict


def print_timings(name, data):
    for key, timings in sorted(data.items()):
        if timings:
            packed_timings = map(lambda t: "%s@%s" % t, sorted(timings.items()))
            print("@{}_{} {}".format(name, key, ' '.join(packed_timings)))


task_finish_re = re.compile("\tmessage=Task (?P<name>\w+)/([^ ]+) (?P<status>completed|failed)")
task_timings_re = re.compile("\tmessage=Task (?P<name>\w+)/([^ ]+) took (?P<schedule_delay>[\d]+) millis to start and took (?P<execution_time>[\d]+) millis to finish")

task_results = defaultdict(Counter)
execution_times = defaultdict(Counter)
schedule_timings = defaultdict(Counter)

for line in sys.stdin:
    if line.strip() == '':
        continue

    if "INFO" not in line and "ERROR" not in line:
        continue

    task_finish_matches = task_finish_re.search(line)
    if task_finish_matches:
        name = task_finish_matches.group('name').replace('.', '_')
        status = task_finish_matches.group('status')
        task_results[name][status] += 1
        task_results['total'][status] += 1

    task_timings_matches = task_timings_re.search(line)
    if task_timings_matches:
        name = task_timings_matches.group('name').replace('.', '_')
        execution_time = str(int(task_timings_matches.group('execution_time')) / float(1000))
        execution_times[name][execution_time] += 1
        execution_times['total'][execution_time] += 1
        schedule_delay = str(int(task_timings_matches.group('schedule_delay')) / float(1000))
        schedule_timings[name][schedule_delay] += 1
        schedule_timings['total'][schedule_delay] += 1

for task, statuses in task_results.items():
    for status in ("completed", "failed"):
        print("{}.{} {}".format(task, status, statuses[status]))

print_timings("task_timings", execution_times)
print_timings("schedule_timings", schedule_timings)
