#!/bin/bash

# Get YARL root stage ID from config file or from script params
if [ -s /etc/yarl/yarl_root ]
then
    ROOT_ID=$(cat /etc/yarl/yarl_root)
else
    ROOT_ID="$1.$2"
fi


TMPL_FILENAME="/etc/yarl/yarl.tmpl"


REALS=$(reals_resolver -from sd -id "$ROOT_ID" | sort)

[ -z "$REALS" ] && exit 0

QUOTA_UPSTREAMS=""
COUNTERS_UPSTREAMS=""

for real in $REALS; do
    QUOTA_UPSTREAMS="$QUOTA_UPSTREAMS
      - type: grpc
        endpoint: \"$real:14589\"
        grpc: *grpc"
    COUNTERS_UPSTREAMS="$COUNTERS_UPSTREAMS
       - endpoint: \"$real:14589\""
done


export QUOTA_UPSTREAMS
export COUNTERS_UPSTREAMS

envsubst \$QUOTA_UPSTREAMS,\$COUNTERS_UPSTREAMS < $TMPL_FILENAME
