function print_timing_graph(name, items) {
  if (length(items)) {
    printf "@%s ", name
    for (item in items) {
      printf " " item "@" items[item]
    }
    printf "\n"
  }
}
function print_graph(items) {
  for (item in items) {
    print item, items[item]
  }
}

/\/ping/ {
  next
}

/\.disk\.yandex\.net/ {
    codes[$(NF-1)]++;
    codes[substr($(NF-1),1,1)"xx"]++;
    codes["total_rps"]++;
    timings[$(NF)]++;
}
END {
    print_graph(codes);
    print_timing_graph("request_timings", timings);
}

