#!/bin/bash

if [[ "$1" =~ -d|--debug ]]; then
   set -x
else
   exec 2>/dev/null
fi

master_pids="`pgrep '^salt-master$'`"

if [[ "$master_pids" ]]; then
   for pid in $master_pids; do
      : $((master_rss_vm_kb+=`awk '/VmRSS/{print $2}' /proc/$pid/status||echo 0`));
   done
   total_memory=`awk '/MemTotal/{print $2}' /proc/meminfo`
   master_rss_vm_percent=$((master_rss_vm_kb/(total_memory/100)))
   if ((master_rss_vm_percent > 50)); then
      lvl=$((lvl>1?lvl:2)) # set 2 if lvl < 2
      msg="${msg}${msg:+, }daemon ate 50% memory"
   fi

   for repo in $(ls -d /srv/salt_repos/*); do   
      if test -e $repo/.git/FETCH_HEAD; then
         repo_file=$repo/.git/FETCH_HEAD;
      else
         if test -e $repo/.svn/wc.db; then
            repo_file=$repo/.svn/wc.db
         else
            lvl=$((lvl>1?lvl:2)) # set 2 if lvl < 2
            msg="${msg}${msg:+, } ERROR: can't find $repo"
         fi
      fi
      if [ -n "$repo_file" ]; then
         last_repo_update_time=$(stat -c "%Y" $repo_file)
         current_time=$(date +%s)
         time_2minutes_ago=$((current_time - 120))
         if (($last_repo_update_time < $time_2minutes_ago));then
            lvl=$((lvl>1?lvl:2)) # set 2 if lvl < 2
            msg="${msg}${msg:+, }${repo} ERROR: last update $((current_time - last_repo_update_time)) seconds ago"
         else
            i=0
            while true; do
               if test -s $repo_file; then
                  break
               else
                  sleep 1
                  if ((i++, i>20));then
                     lvl=$((lvl>1?lvl:2)) # set 2 if lvl < 2
                     msg="${msg}${msg:+, }${repo} ERROR: EMPTY $repo_file (remote update failed)"
                     break
                  fi
               fi
            done
         fi
      fi
   done
else
   lvl=$((lvl>1?lvl:2)) # set 2 if lvl < 2
   msg="${msg}${msg:+, }daemon not alive"
fi

echo "${lvl:-0};${msg:-ok}"