#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import os
import re
import sys
import time
import urllib2
import json
import pprint
from collections import defaultdict
import time

def http_get_json_cache(url, cache_file, cache_ttl = 300, retries = 1, sleep = 1):

    cache_need_update = True
    if os.path.exists(cache_file):
        ts_now = time.time()
        ts_cache = os.path.getmtime(cache_file)
        if (ts_now - ts_cache) < cache_ttl:
            cache_need_update = False

    if cache_need_update:
        json_data = http_get_json(url, retries, sleep)
        if json_data:
            update_cache(json.dumps(json_data), cache_file)

    cache_data = get_cache(cache_file)
    json_data = json.loads(cache_data)

    return json_data;

def http_get (url,retries,sleep):
    bdata = False
    for i in xrange(retries):
        try:
            http_req = urllib2.urlopen(url)
            if http_req.getcode() != 200 :
                bdata = False
            else:
                bdata = http_req.read()
                break
        except:
            bdata = False
    return bdata


def http_get_json(url, retries, sleep):
    json_data = dict()
    for i in xrange(retries):
        try:
            bdata = http_get(url, retries, sleep)
            json_data = json.loads(bdata)
            if len(json_data) < 1:
                json_data = False
            else:
                break
        except:
            json_data = False
    return json_data


def update_cache(data, cache_file):
    result = dict()
    try:
        cache_dir = os.path.dirname(cache_file)
        if not os.path.exists(cache_dir):
            os.mkdir(cache_dir)

        cache_fd = open(cache_file, "w")
        cache_fd.write(data)
        cache_fd.close()
    except:
        result = False

    return result


def get_cache(cache_file):
    try:
        cache_fd = open(cache_file, "r")
        result = cache_fd.read()
        cache_fd.close()
    except:
        result = False

    return result




### get task on queue mapping from search

search_queuestat_retries = 1
search_queuestat_sleep = 1


qeueuestat = dict()
search_queuestat_url = "http://sinx.mail.yandex.net:8171/zoo/disk/queuelen1"
queuestat = http_get(url = search_queuestat_url,retries = search_queuestat_retries, sleep = search_queuestat_sleep)
#pprint.pprint(queuestat)
results_errors = { 'parse' : 0 }

# Collect errors from logs
results_log_errors = dict()
for error in ['parse']:
    results_log_errors[error] = 0


results_queuestat = { 'queue_callback' : 0 }

for line in queuestat.splitlines():
    if line.strip() == '':
        continue
    parts = line.split('\t')
    if parts[2] == "callbacks.queue":
        results_queuestat['queue_callback'] += int(parts[3])

for item, value in sorted (results_queuestat.iteritems()):
    print("count_%s %s" % (item, value))

